<?php
/****************************************
 * XKLog 静态控制函数库
 *
 * 此文件定义所有 page_ 函数
 *
 * 更新：2009-06-26
 * 版本：V1.0
 ****************************************/

!defined('IN_XKLOG') && exit('Access Denied!');

function page_make( $article_id, $article_type ) {
	if( $article_type == '动态' ) {
		return;
	}elseif( $article_type == '半静态' ) {
		page_make_php( $article_id );
	}else{
		page_make_html( $article_id );
	}
}

function page_make_html( $article_id ) {
	global $_CACHE,$_ENV,$db;

	$_ENV['page_make'] = true;

	$_ENV['id'] = $article_id;
	require( XKLOG_ROOT . './function/mod_read.php');

	$contents = ob_get_contents();
	obclean();

	$category = $db->result( 'SELECT Alias FROM `' . PREFIX_STR . 'Category`,`' . PREFIX_STR . 'Article` WHERE ID=' . $article_id . ' AND Category=CID' );
	$address = $db->result( 'SELECT Address FROM `' . PREFIX_STR . 'Article` WHERE ID=' . $article_id );
	$file_path = XKLOG_ROOT . '/article/' . $category . '/';
	if ( !is_dir( $file_path ) ) {
		@mkdir( $file_path, 0777 );
	}
	if( $address == '' ) {
		$file_path .= $article_id . '.html';
	}else{
		$file_path .= $address . '.html';
	}
	file_put_contents( $file_path, $contents );
	$contents = '';
	unset($contents);
}

function page_make_php( $article_id ) {
	global $db;
	$category = $db->result( 'SELECT Alias FROM `' . PREFIX_STR . 'Category`,`' . PREFIX_STR . 'Article` WHERE ID=' . $article_id . ' AND Category=CID' );
	$address = $db->result( 'SELECT Address FROM `' . PREFIX_STR . 'Article` WHERE ID=' . $article_id );
	$file_path = XKLOG_ROOT . '/article/' . $category . '/';
	if ( !is_dir( $file_path ) ) {
		@mkdir( $file_path, 0777 );
	}
	if( $address == '' ) {
		$file_path .= $article_id . '.php';
	}else{
		$file_path .= $address . '.php';
	}
	$article_id = max(1, $article_id);
	$contents = "<?php\r\nrequire('../../include/loader.php');\r\n@header(\"content-Type: text/html; charset=utf-8\");\r\n";
	$contents .= '$_ENV[\'id\'] = ' . $article_id . ';';
	$contents .= "\r\nrequire('../../function/mod_read.php');\r\n?>";
	file_put_contents( $file_path, $contents );
	$contents = '';
	unset($contents);
}
?>